const crypto = require("crypto");
const jwt = require("jsonwebtoken");
const User = require("../models/User");
const { sendEmail, sendEmailSES, sendEm, sendEmailSESS, registerEmailVerification, forgetPasswordEmail, forgetUserNameEmail } = require("../utils/sendEmail");
const Cryptr = require("cryptr");
const Token = require("../models/tokenModel");
const cryptr = new Cryptr(process.env.CRYPTR_KEY);


const register = async (req, res, next) => {
  const { firstName, lastName, gender, accountType, dob, username, email, recoveryEmail, password , referred_by ,business =null } = req.body;

  if (!firstName || !lastName || !accountType ||  !username || !email || !password || !recoveryEmail) {
    res.status(400);
    return next(new Error("Please provide username, email and password"));
  }

  // Check if user already exists
  const userExists = await User.findOne({ recoveryEmail });

  if (userExists) {
    res.status(400);
    return next(new Error("Recovery Email already exists"));
  }

  try {
    const user = await User.create({
      firstName,
      lastName,
      gender,
      accountType,
      dob,
      username,
      email,
      recoveryEmail,
      password,
      referred_by,
      business
    });
    // generate 6 digit code
    const loginCode = Math.floor(100000 + Math.random() * 900000);
    console.log( "loginCode ",loginCode);

    // Encrypt login code before saving to DB
    const encryptedLoginCode = cryptr.encrypt(loginCode.toString());

    // Delete Token if it exists in DB
    let userToken = await Token.findOne({ userId: user._id });
    if (userToken) {
      await userToken.deleteOne();
    }

    // Save Tokrn to DB
    await new Token({
      userId: user._id,
      lToken: encryptedLoginCode,
      createdAt: Date.now(),
      expiresAt: Date.now() + 60 * (60 * 1000), // 60mins
    }).save();

    // Send Login Code
    const subject = "Login Access Code - Verify";
    const send_to = recoveryEmail;
    const sent_from = process.env.EMAIL_USER;
    const reply_to = "noreply@clikkle.com";
    const template = "loginCode";
    const name = user.username;
    const Code = loginCode;

    await registerEmailVerification({
      send_to,
      sent_from,
      reply_to,
      name,
      otp:Code
    })

    // await sendEmail(
    //   template,
    //   send_to,
    //   sent_from,
    //   reply_to,
    //   name,
    //   Code,
    //   subject
    // );
    try {
      return res.status(201).json({
        success: true,
        user
      });
      // res.status(200).json({ message: `Access code sent to ${email}` });
    } catch (error) {
      // res.status(500);
      throw new Error("Email not sent, please try again");
    }
  } catch (error) {
    console.log('..err', error);
    next(error);
  }


};
// Login With Code
const loginWithCode = async (req, res, next) => {
  const { loginCode, recoveryEmail } = req.body;
  const user = await User.findOne({ recoveryEmail });

  if (!user) {
    res.status(404);
    throw new Error("User not found");
  }
  // Find user Login Token
  const userToken = await Token.findOne({
    userId: user._id,
  });

  const decryptedLoginCode = cryptr.decrypt(userToken.lToken);
  if (loginCode !== decryptedLoginCode) {
    res.status(400);
    // throw new Error("Incorrect login code, please try again");
    return next(new Error("Incorrect code, please try again"));
  } else {

    const ip = req.headers['x-forwarded-for'] || req.socket.remoteAddress;
    const formattedIp = ip.includes('::ffff:') ? ip.split('::ffff:')[1] : ip;
    console.log('IP address:', formattedIp);

    // Now verify user
    user.registerIpAddress = ip;
    user.isVerified = true;
    await user.save();

   let response =  generateToken(user, 201, res);

    // res.status(200).json({
    //   success: true
    // })

  }
};

const generateName = async ( name , day , month , year ) =>{

  try {
    
  let username =  name + day;
  let result = await User.findOne({ username });
  if(!result){
    return username
  }

   username =  name + month;
   result = await User.findOne({ username });
  if(!result){
    return username
  }

  username =  name + year;
  result = await User.findOne({ username });
  if(!result){
    return username
  }

  for(let i =0;i<999999 ; i++){
    result = await User.findOne({ username });
    if(!result){
      return username;
    }
  }
  } catch (error) {
    throw new Error("unable to generate name");
  }

}

//
const suggestUserName = async (req, res, next) => {
  const { firstName , lastName , day , month , year  } = req.body;

  try {
      
    let sug1 =  await generateName( (firstName + lastName ),day , month , year)
    let sug2 =  await generateName( ( lastName+firstName  ),year,day , month )
   
    res.status(200).json({
      success: true,
      data: [sug1 ,sug2]
    })

} catch (error) {
  res.status(500).json({
    success: false ,
    message: JSON.stringify(err.message) 
  }); 
}

};

const logout = async (req, res, next) => {

  const {  sessionToken, userId  } = req.body;
  try {
    const decoded = await jwt.verify(sessionToken, process.env.JWT_REFRESH_SECRET);
    // Get user from token

    if(String(userId ) !== String(decoded.id)){
      res.status(400);
      return next(new Error("User does not Match"));
    }

     let user = await User.findById(decoded.id);
    if (!user) {
      res.status(400);
      return next(new Error("User does not exists"));
    }
    user.session = false;
    await user.save();
    return res.status(200).json({
      success: true,
      message: 'User logout successfully'
    });   
  } catch (err) {

    if (err?.name === 'TokenExpiredError') {
      res.status(401).json({
        success: false ,
        message: 'Token has expired'
      });
    } else if (err.name === 'JsonWebTokenError') {
      res.status(400).json({
        success: false ,
        message: 'Token is invalid'
      });
    } else {
      res.status(500).json({
        success: false ,
        message: JSON.stringify(err.message) 
      });
    }
  }
};

const loginWithSession = async (req, res, next) => {

  const { sessionToken, userId  } = req.body;
  try {
    const decoded = await jwt.verify(sessionToken, process.env.JWT_REFRESH_SECRET);
    // Get user from token

    if(String(userId ) !== String(decoded.id)){
      res.status(400);
      return next(new Error("User does not Match"));
    }

    let user = await User.findById(decoded.id);
    if (!user) {
      res.status(400);
      return next(new Error("User does not exists"));
    }

    if (!user.session) {
      res.status(400);
      return next(new Error("User logout"));
    }

   let response = generateToken(user, 201, res);
    
  } catch (err) {

    if (err?.name === 'TokenExpiredError') {
      res.status(401).json({
        success: false ,
        message: 'Token has expired'
      });
    } else if (err.name === 'JsonWebTokenError') {
      res.status(400).json({
        success: false ,
        message: 'Token is invalid'
      });
    } else {
      res.status(500).json({
        success: false ,
        message: JSON.stringify(err.message) 
      });
    }
  }
};

const logoutWithSession = async (req, res, next) => {

  const { refreshToken } = req.body;
  try {
    const decoded = await jwt.verify(refreshToken, process.env.JWT_REFRESH_SECRET);
    // Get user from token

    let user = await User.findById(decoded.id);

    if (!user) {
      res.status(400);
      return next(new Error("User does not exists"));
    }

    user.session = false;
    await user.save();

    return res.status(200).json({
      success: true,
      message: 'User logout successfully'
    });
    
  } catch (err) {

    if (err?.name === 'TokenExpiredError') {
      res.status(401).json({
        success: false ,
        message: 'Token has expired'
      });
    } else if (err.name === 'JsonWebTokenError') {
      res.status(400).json({
        success: false ,
        message: 'Token is invalid'
      });
    } else {
      res.status(500).json({
        success: false ,
        message: JSON.stringify(err.message) 
      });
    }
  }
};

//Resend Token
const resendToken = async (req, res) => {
  const { recoveryEmail } = req.body;
  const user = await User.findOne({ recoveryEmail });

  if (!user) {
    res.status(404);
    throw new Error("User not found");
  }
  // generate 6 digit code
  const loginCode = Math.floor(100000 + Math.random() * 900000);
  console.log(loginCode);

  // Encrypt login code before saving to DB
  const encryptedLoginCode = cryptr.encrypt(loginCode.toString());

  // Delete Token if it exists in DB
  let userToken = await Token.findOne({ userId: user._id });
  if (userToken) {
    await userToken.deleteOne();
  }

  // Save Tokrn to DB
  await new Token({
    userId: user._id,
    lToken: encryptedLoginCode,
    createdAt: Date.now(),
    expiresAt: Date.now() + 60 * (60 * 1000), // 60mins
  }).save();
  // // Find user Login Token
  // const userToken = await Token.findOne({
  //   userId: user._id,
  // });

  // const decryptedLoginCode = cryptr.decrypt(userToken.lToken);
  // console.log('Recovery Email', recoveryEmail, user, decryptedLoginCode)

  // Send Login Code
  const subject = "Login Access Code - Verfify";
  const send_to = recoveryEmail;
  const sent_from = process.env.EMAIL_USER;
  const reply_to = "noreply@zino.com";
  const template = "loginCode";
  const name = user.username;
  const Code = loginCode;


  await registerEmailVerification({
    send_to,
    sent_from,
    reply_to,
    name,
    otp:Code
  }).then((emailRes) => {
    // console.log('ema',emailRes);
    if (emailRes) {
      res.status(200).json({
        success: true
      })
    }
  });

  // await sendEmail(
  //   template,
  //   send_to,
  //   sent_from,
  //   reply_to,
  //   name,
  //   Code,
  //   subject
  // ).then((emailRes) => {
  //   // console.log('ema',emailRes);
  //   if (emailRes) {
  //     res.status(200).json({
  //       success: true
  //     })
  //   }
  // });



};

// add phone 
const addPhone = async (req, res) => {
  const { email, phoneNumber } = req.body;
  const user = await User.findOne({ email });
  // console.log('ad',req.body,user)

  if (!user) {
    res.status(404);
    throw new Error("User not found");
  }
  user.phoneNumber = phoneNumber;
  await user.save();

  res.status(200).json({
    success: true,
    user
  })

};

const login_email = async (req, res, next) => {

  const { email } = req.body;

  if (!email) {
    res.status(400);
    return next(new Error("Please provide email"));
  }

  // Check if user exists
  const user = await User.findOne({ email });

  if (!user) {
    res.status(400);
    return next(new Error("Email does not exists"));
  }

  res.status(200).json({
    success: true,
    message: "Email exists",
  });
};


const verify_login = async (req, res, next) => {
  const { refreshToken } = req.body;
  try {
    const decoded = await jwt.verify(refreshToken, process.env.JWT_REFRESH_SECRET);
    // Get user from token
    let user = await User.findById(decoded.id);
    if (!user) {
      res.status(400);
      return next(new Error("User does not exists"));
    }

    if (!user.session) {
      res.status(400);
      return next(new Error("User logout"));
    }

    res.status(200).json({
      success: true,
      message: "login Successfully",
      user
    });
  } catch (err) {

    if (err?.name === 'TokenExpiredError') {
      res.status(401).json({
        success: false ,
        message: 'Token has expired'
      });
    } else if (err.name === 'JsonWebTokenError') {
      res.status(400).json({
        success: false ,
        message: 'Token is invalid'
      });
    } else {
      res.status(500).json({
        success: false ,
        message: JSON.stringify(err.message) 
      });
    }
  }

};


const check_email = async (req, res, next) => {
  const { email } = req.body;

  if (!email) {
    res.status(400);
    return next(new Error("Please provide email"));
  }

  // Check if user exists
  const user = await User.findOne({ email });

  if (user) {
    res.status(400);
    return next(new Error("Email exists"));
  }

  res.status(200).json({
    success: true,
    message: "Email does not exists",
  });
}

const get_user_by_mail = async (req, res, next) => {
  const { email } = req.body;

  if (!email) {
    res.status(400);
    return next(new Error("Please provide email"));
  }

  // Check if user exists
  const user = await User.findOne({ email });

  if (!user) {
    res.status(400);
    return next(new Error("Email does not exists"));
  }

  res.status(200).json({
    success: true,
    message: "Email exists",
    data  : user
  });
}

const get_user_profile = async (req, res, next) => {
  try {
    const { id } = req.body;

    if (!id) {
      return res.status(400).json({
        success: false,
        message: 'User ID is required.'
      });
    }

    const user = await User.findOne({ _id: id });

    if (!user) {
      return res.status(404).json({
        success: false,
        message: 'User not found.'
      });
    }

    return res.status(200).json({
      success: true,
      user
    });
  } catch (error) {
    console.error(error);
    return res.status(500).json({
      success: false,
      message: 'An error occurred while retrieving the user profile.'
    });
  }
};


const get_all_users = async (req, res, next) => {
  const users = await User.find();
  const statusCode = 200;
  return res.status(statusCode).json({
    success: true,
    users
  });

};

const login = async (req, res, next) => {
  const { email, password } = req.body;
  // console.log('user',req.body)
  if (!email || !password) {
    res.status(400);
    return next(new Error("Please provide email and password"));
  }

  // Check if user exists
  const user = await User.findOne({ email }).select("+password");

  if (!user) {
    res.status(400);
    return next(new Error("User does not exists"));
  }
  
  if (user && !user.isVerified) {
    res.status(400);
    return next(new Error("User not verified"));
  }

  try {
    const isMatch = await user.matchPasswords(password);
    // const isMatch = user.password === password

    if (!isMatch) {
      res.status(400);
      return next(new Error("User password does not match"));
    }

    const response = await generateToken(user, 200, res);

  } catch (error) {
    next(error);
  }
};

const forgotPassword = async (req, res, next) => {
  const { email } = req.body;

  if (!email) {
    res.status(400);
    return next(new Error("Please provide email"));
  }

  // Check if user exists
  const user = await User.findOne({ email });

  if (!user) {
    res.status(400);
    return next(new Error("User does not exists"));
  }

  try {
    const resetToken = user.getResetPasswordToken();
    await user.save();

    const resetUrl = `http://localhost:3000/passwordreset/${resetToken}`;
    const message = `
    <h1>You have requested a password reset</h1>
    <p>Please go to this link to reset your password</p>
    <a href=${resetUrl} clicktracking=off>${resetUrl}</a>
    `;
 // generate 6 digit code
 const loginCode = Math.floor(100000 + Math.random() * 900000);
 console.log( "forget code ",loginCode);

 // Encrypt login code before saving to DB
 const encryptedLoginCode = cryptr.encrypt(loginCode.toString());

 // Delete Token if it exists in DB
 let userToken = await Token.findOne({ userId: user._id });
 if (userToken) {
   await userToken.deleteOne();
 }

 // Save Tokrn to DB
 await new Token({
   userId: user._id,
   lToken: encryptedLoginCode,
   createdAt: Date.now(),
   expiresAt: Date.now() + 15 * (60 * 1000), // 60mins
 }).save();

    try {
      const send_to = user.recoveryEmail;
      const sent_from = process.env.EMAIL_USER;
      const reply_to = "noreply@zino.com";
      const name = user.username;
      const otp = loginCode;

      await forgetPasswordEmail({
        send_to,
        sent_from,
        reply_to,
        name,
        otp
      })
      // await sendEmail({
      //   to: user.email,
      //   subject: "Password Reset Request",
      //   html: message,
      // });
      return res.status(200).json({
        success: true,
        message: "Email was sent!",
      });
    } catch (error) {
      user.resetPasswordToken = undefined;
      user.resetPasswordExpire = undefined;
      res.status(500);
      return next(new Error("Email could not be sent"));
    }
  } catch (error) {
    next(error);
  }
};

const forgotMail = async (req, res, next) => {
  const { recoveryEmail , type , phoneNumber } = req.body;
  let user;
  if(type =="phone"){
    if (!phoneNumber) {
      res.status(400);
      return next(new Error("Please provide recovery phoneNumber"));
    }
  
    // Check if user exists
   user = await User.findOne({ phoneNumber });

  }else {

    if (!recoveryEmail) {
      res.status(400);
      return next(new Error("Please provide recovery Email"));
    }
  
    // Check if user exists
   user = await User.findOne({ recoveryEmail });
  }



  if (!user) {
    res.status(400);
    return next(new Error("User does not exists"));
  }

  try {


    try {
      const send_to = user.recoveryEmail;
      const sent_from = process.env.EMAIL_USER;
      const reply_to = "noreply@clikkle.com";
      const username = user.username;
      const  name = ( user.firstName  + " "+user.lastName);
      const email = user.email;

      await forgetUserNameEmail({
        send_to,
        sent_from,
        reply_to,
        name,
        username,
        email
      })
      return res.status(200).json({
        success: true,
        message: "Email was sent!",
      });
    } catch (error) {
      res.status(500);
      return next(new Error("Email could not be sent"));
    }
  } catch (error) {
    next(error);
  }
};

const resetPassword = async (req, res, next) => {
  const { password  , otp  , email } = req.body;
  
  try {

  if (!password || !otp || !email) {
    res.status(400);
    return next(new Error(`Please provide  ${ !password &&  "password"} ${ !otp &&  "otp"}${ !email &&  "email"} `));
  }

  const user = await User.findOne({ email });

  if (!user) {
    res.status(404);
    throw new Error("User not found");
  }
  // Find user Login Token
  const userToken = await Token.findOne({
    userId: user._id,
  });

  const decryptedLoginCode = cryptr.decrypt(userToken.lToken);
  if (otp !== decryptedLoginCode) {
    res.status(400);
    // throw new Error("Incorrect login code, please try again");
    return next(new Error("Incorrect code, please try again"));
  } else {
    try {
      user.password = password;
      await user.save();
  
      res.status(200).json({
        success: true,
        message: "Password Reset Success",
      });
    } catch (e) {
      next(e);
    }
  }

} catch (error) {
  next(error); 
}




};

const generateToken = async (user, statusCode, res) => {

  const token = user.getSignedToken();
  const refreshToken = user.getRefreshToken();
  const sessionToken = user.getRefreshToken();
  user.session = true;
  await user.save();

  return res.status(statusCode).json({
    success: true,
    token,
    refreshToken,
    sessionToken,
    user
  });
};


module.exports = {
  register,
  login_email,
  login,
  forgotPassword,
  resetPassword,
  get_all_users,
  get_user_profile,
  loginWithCode,
  resendToken,
  addPhone,
  check_email,
  verify_login,
  get_user_by_mail,
  forgotMail,
  loginWithSession,
  logout,
  logoutWithSession,
  suggestUserName
};
