const express = require("express");
const {
  register,
  login_email,
  login,
  forgotPassword,
  resetPassword,
  get_all_users,
  get_user_profile,
  loginWithCode,
  resendToken,
  addPhone,
  check_email,
  verify_login,
  get_user_by_mail,
  forgotMail,
  loginWithSession,
  logout,
  logoutWithSession,
  suggestUserName,
} = require("../controllers/auth");
// const {sendEmailSES} = require("../utils/sendEmail");
const router = express.Router();

router.route("/register").post(register);
router.route("/suggest_name").post(suggestUserName);
router.route("/register_code").post(loginWithCode);
router.route("/session/login").post(loginWithSession);
router.route("/logout").post(logout);
router.route("/session/logout").post(logoutWithSession);
router.route("/resend_code").post(resendToken);
router.route("/add_phone").post(addPhone);
router.route("/login_email").post(login_email);
router.route("/verify_login").post(verify_login);
router.route('/check_email').post(check_email);
router.route('/get_user_by_mail').post(get_user_by_mail)
router.route("/login").post(login);
router.route("/forgotPassword").post(forgotPassword);
router.route("/forgotMail").post(forgotMail);
router.route("/resetPassword").put(resetPassword);
router.route("/get_all_users").get(get_all_users);
router.route("/get_user_profile").post(get_user_profile);
module.exports = router;
